<?php

ob_start();
// Assuming you've fetched the city data from a database as mentioned above
$cityId = $_GET['id'];  // Get city ID
$pdo = new PDO('mysql:host=localhost;dbname=meetup', 'root', '');  // Adjust connection details
$stmt = $pdo->prepare('SELECT * FROM tablecities WHERE id = :id');
$stmt->execute(['id' => $cityId]);
$cityData = $stmt->fetch(PDO::FETCH_ASSOC);

?>
<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <div class="row align-items-center">
      <div class="col">
        <div class="d-flex align-items-center gap-4">
          <h1 class="h4 ls-tight">Update City</h1>
        </div>
      </div>
    </div>
  </header>
    <form id="updateCityForm">
    <div class="row">
      <div class="col-md-4">
        <div class="form-group">
        <label for="id" class="form-lable">City ID:</label>
        <input type="text" class="form-control"  id="id" name="id" value="<?php echo $cityData['id']; ?>" required>
      </div>
      </div>
        <div class="col-md-4">
          <div class="form-group">
          <label for="city" class="form-lable">City Name:</label>
          <input type="text" id="city" name="city" class="form-control" value="<?php echo $cityData['city']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="cityfirstletter" class="form-lable">City First Letter:</label>
              <input type="text" id="cityfirstletter" class="form-control" name="cityfirstletter" value="<?php echo $cityData['cityfirstletter']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
            <label for="lat" class="form-lable">Latitude:</label>
            <input type="number" id="lat" name="lat" class="form-control" value="<?php echo $cityData['lat']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="lng" class="form-lable">Longitude:</label>
              <input type="number" id="lng" name="lng" class="form-control" value="<?php echo $cityData['lng']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="country" class="form-lable">Country:</label>
              <input type="text" id="country" name="country" class="form-control" value="<?php echo $cityData['country']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="country_iso" class="form-lable">Country ISO Code:</label>
              <input type="text" id="country_iso" name="country_iso" class="form-control" value="<?php echo $cityData['country_iso']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
             <label for="state" class="form-lable">State:</label>
             <input type="text" id="state" name="state" class="form-control" value="<?php echo $cityData['state']; ?>" required>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="comment" class="form-lable">Comment:</label>
               <textarea id="comment" name="comment" class="form-control"><?php echo $cityData['comment']; ?></textarea>
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
            <label for="populationgreaterarea" class="form-lable">Population of Greater Area:</label>
             <input type="number" id="populationgreaterarea" name="populationgreaterarea" class="form-control" value="<?php echo $cityData['populationgreaterarea']; ?>" >
          </div>
        </div>
          <div class="col-md-4">
            <div class="form-group">
              <label for="populationcity" class="form-lable">Population of City:</label>
              <input type="number" id="populationcity" class="form-control" name="populationcity" value="<?php echo $cityData['populationcity']; ?>" >
          </div>
        </div>
    </div>
    <div class="float-end mt-4">
      <button class="btn btn-success text-white" type="submit">Update City</button>
    </div>
      
    </form>
</main>
<!-- jQuery CDN (if not already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
        $('#updateCityForm').on('submit', function(e) {
            e.preventDefault(); // Prevent the default form submission

            let formData = {
                id: $('#id').val(),
                city: $('#city').val(),
                cityfirstletter: $('#cityfirstletter').val(),
                lat: $('#lat').val(),
                lng: $('#lng').val(),
                country: $('#country').val(),
                country_iso: $('#country_iso').val(),
                state: $('#state').val(),
                comment: $('#comment').val(),
                populationgreaterarea: $('#populationgreaterarea').val(),
                populationcity: $('#populationcity').val()
            };

            $.ajax({
                url: 'http://localhost/gomeetapi/updatecity.php',  // Replace with the correct API URL
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    if (response.status) {
                        $('#responseMessage').html('<p class="btn btn-success">City updated successfully!</p>');
                        // Redirect to cities list page after 2 seconds
                        setTimeout(function() {
                            window.location.href = 'cities.php'; // Replace with the correct cities list page URL
                        }, 1000);
                    } else {
                        $('#responseMessage').html('<p class="btn btn-warning">Failed to update city: ' + response.message + '</p>');
                    }
                },
                error: function(xhr, status, error) {
                    $('#responseMessage').html('<p>Error occurred while updating city: ' + error + '</p>');
                }
            });
        });
    });
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>