<?php
ob_start();
$assmentId = $_GET['id'];
$pdo = new PDO('mysql:host=localhost;dbname=meetup', 'root', '');

$stmt = $pdo->prepare('SELECT * FROM assesmentanswers WHERE id = :id');
$stmt->execute(['id' => $assmentId]);
$assesmentData = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <h1 class="h4 ls-tight">Update Assessment Answers</h1>
  </header>

  <div id="responseMessage" class="my-3"></div>

  <form id="updateAssessmentForm">
    <input type="hidden" id="id" name="id" value="<?= $assesmentData['id']; ?>">

    <div class="row g-3 mt-6">
      <div class="col-md-6">
        <label>User ID</label>
        <input type="number" id="userid" name="userid" class="form-control" value="<?= $assesmentData['userid']; ?>" required>
      </div>

      <div class="col-md-6">
        <label>Type</label>
        <input type="text" id="type" name="type" class="form-control" value="<?= $assesmentData['type']; ?>" required>
      </div>

      <div class="col-md-6">
        <label>Category ID</label>
        <input type="number" id="categoryid" name="categoryid" class="form-control" value="<?= $assesmentData['categoryid']; ?>" required>
      </div>

      <div class="col-md-6">
        <label>Question ID</label>
        <input type="number" id="questionid" name="questionid" class="form-control" value="<?= $assesmentData['questionid']; ?>" required>
      </div>

      <div class="col-md-12">
        <label>Answer</label>
        <textarea id="answer" name="answer" class="form-control" required><?= $assesmentData['answer']; ?></textarea>
      </div>

      <div class="col-md-6">
        <label>Rating (1-5)</label>
        <input type="number" id="rating" name="rating" class="form-control" min="1" max="5" value="<?= $assesmentData['rating']; ?>" required>
      </div>
    </div>

    <div class="float-end mt-4">
      <button class="btn btn-success text-white" type="submit">Update</button>
    </div>
  </form>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $(document).ready(function () {
    $('#updateAssessmentForm').on('submit', function (e) {
      e.preventDefault();

      const id = $('#id').val();
      const formData = {
        userid: $('#userid').val(),
        type: $('#type').val(),
        categoryid: $('#categoryid').val(),
        questionid: $('#questionid').val(),
        answer: $('#answer').val(),
        rating: $('#rating').val()
      };

      $.ajax({
        url: 'http://localhost/gomeetapi/updateassessment/' + id,
        type: 'PUT',
        contentType: 'application/json',
        data: JSON.stringify(formData),
        success: function (response) {
          let res;
          try {
            res = typeof response === 'string' ? JSON.parse(response) : response;
          } catch (e) {
            $('#responseMessage').html('<div class="alert alert-danger">Invalid JSON from server</div>');
            return;
          }

          if (res.Result === "true") {
            $('#responseMessage').html('<div class="alert alert-success">Assessment updated successfully!</div>');
            setTimeout(() => window.location.href = 'assesmentanswers.php', 1500);
          } else {
            $('#responseMessage').html('<div class="alert alert-warning">' + res.ResponseMsg + '</div>');
          }
        },
        error: function (xhr, status, error) {
          $('#responseMessage').html('<div class="alert alert-danger">AJAX error: ' + error + '</div>');
        }
      });
    });
  });
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
