<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start();
$assmentId = $_GET['id'];
$pdo = new PDO('mysql:host=localhost;dbname=funtxjyc_gomeet', 'funtxjyc_gomeet', 'funtxjyc_gomeet');

$stmt = $pdo->prepare('SELECT * FROM assessmentquestions WHERE id = :id');
$stmt->execute(['id' => $assmentId]);
$assesmentData = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <h1 class="h4 ls-tight">Update Assessment Question</h1>
  </header>

  <div id="responseMessage" class="my-3"></div>

  <form id="updateAssessmentForm">
    <input type="hidden" id="id" name="id" value="<?= $assesmentData['id']; ?>">

    <div class="row g-3 mt-6">
      <div class="col-md-4">
        <label>Question</label>
        <input type="text" id="question" name="question" class="form-control" value="<?= $assesmentData['question']; ?>" required>
      </div>

        <div class="col-md-4">
        <label>Options</label>
        <input type="text" id="options" name="options" class="form-control" value="<?= $assesmentData['options']; ?>" required>
      </div>

      <div class="col-md-4">
        <label>Category ID</label>
        <input type="number" id="categoryid" name="categoryid" class="form-control" value="<?= $assesmentData['categoryid']; ?>" required>
      </div>

      <div class="col-md-6">
        <label>Created By</label>
        <input type="text" id="createdby" name="createdby" class="form-control" value="<?= $assesmentData['createdby']; ?>" required>
      </div>

      <div class="col-md-6">
        <label>Rating (1-5)</label>
        <input type="text" id="ratings" name="ratings" class="form-control" min="1" max="5" value="<?= $assesmentData['ratings']; ?>" required>
      </div>
    </div>

    <div class="float-end mt-4">
      <button class="btn btn-success text-white" type="submit">Update</button>
    </div>
  </form>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function () {
  $('#updateAssessmentForm').on('submit', function (e) {
    e.preventDefault();

    const id = $('#id').val();
    const formData = {
      id: id,
      question: $('#question').val(),
      options: $('#options').val(),
      categoryid: $('#categoryid').val(),
      createdby: $('#createdby').val(),
      ratings: $('#ratings').val()
    };

    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/updateassessmentquestion.php',
      type: 'POST',
      dataType: 'json',
      data: formData,
      success: function (res) {
        if (res.Result === "true") {
          $('#responseMessage').html('<div class="alert alert-success">Assessment updated successfully!</div>');
          setTimeout(() => window.location.href = 'assesmentquestions.php', 1500);
        } else {
          $('#responseMessage').html('<div class="alert alert-warning">' + res.ResponseMsg + '</div>');
        }
      },
      error: function (xhr) {
        $('#responseMessage').html('<div class="alert alert-danger">Server Error</div>');
      }
    });
  });
});
</script>



<?php
$content = ob_get_clean();
include '../layouts/master.php';
