<?php
ob_start();
?>
<main class="container-fluid p-0">
  
<div class="modal fade" id="viewReportModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable" style="min-width:1000px;">

        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">User Report</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div id="reportContent">
                
                </div>
            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

    <div class="px-6 px-lg-7 pt-8 border-bottom mb-4">
        <div class="row mb-5">
            <div class="col-12 col-md-6">
                <h2>Reports</h2>
            </div>
            <div class="col-12 col-md-6 d-flex justify-content-end">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addWeekModal">+ Add</button>

            </div>
            <div class="hstack gap-2 ms-auto"></div>
        </div>
    </div>
    <div class="row float-end m-auto d-flex justify-content-end mt-4">
        <div class="px-6 col-md-4">
            <div class="mb-3">
                <input type="text" id="userSearch" class="form-control" placeholder="Search Users...">
            </div>
        </div>
    </div>
    <div class="container">
       <table class="table" id="weeksTable">
    <thead>
        <tr>
            <th>#</th>
            <th>Full Name</th>
            <th>Category</th>
            <th>Week</th>
            <th>Answers Submitted</th>
            <th>View Report</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>1</td>
            <td>Haris Shaheed</td>
            <td>Love Language</td>
            <td>First Week</td>
            <td>10</td>
            <td><button class="btn btn-sm btn-info viewReportBtn">View</button></td>
        </tr>

        <tr>
            <td>2</td>
            <td>Ali Raza</td>
            <td>Communication</td>
            <td>Second Week</td>
            <td>8</td>
            <td><button class="btn btn-sm btn-info viewReportBtn">View</button></td>
        </tr>

        <tr>
            <td>3</td>
            <td>Ahmed Khan</td>
            <td>Emotional Needs</td>
            <td>Third Week</td>
            <td>12</td>
            <td><button class="btn btn-sm btn-info viewReportBtn">View</button></td>
        </tr>
    </tbody>
</table>


    </div>

    <div class="py-4 px-6">
        <div class="row align-items-center justify-content-between">
            <div class="col-md-6 d-none d-md-block"></div>
            <div class="col-md-auto">
                <nav aria-label="Page navigation"></nav>
            </div>
        </div>
    </div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


<script>
$(document).ready(function() {

    // Static report data (for now)
    const reportData = [
        { question: "How do you express love?", answer: "Through words and actions." },
        { question: "Do you feel emotionally supported?", answer: "Most of the time." },
        { question: "How do you handle conflicts?", answer: "By communicating calmly." },
        { question: "Do you feel heard in your relationship?", answer: "Yes, generally." },
        { question: "How often do you spend quality time together?", answer: "Weekly." },
        { question: "What makes you feel appreciated?", answer: "Small thoughtful gestures." },
        { question: "How do you react under stress?", answer: "I become quiet and reflective." },
        { question: "Do you openly share your feelings?", answer: "Yes, but selectively." },
        { question: "What causes misunderstandings?", answer: "Lack of clarity." },
        { question: "How satisfied are you overall?", answer: "Very satisfied." }
    ];

    // Open report modal
    $(document).on('click', '.viewReportBtn', function() {

        let html = `
            <div class="mb-4">
              
                <p class="text-muted">
                    Below is the detailed response report submitted by the user.
                </p>
            </div>

            <div class="row g-3">
        `;

        reportData.forEach((item, index) => {
            html += `
                <div class="col-12 col-md-6">
                    <div class="card h-100 shadow-sm">
                        <div class="card-body">
                            <h6 class="fw-bold mb-2">
                                <span class="text-primary">Question ${index + 1}:</span>
                                ${item.question}
                            </h6>

                            <div class="border rounded p-2">
                                <span class="text-primary fw-bold">Answer:</span>
                                <div class="mt-1">${item.answer}</div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });

        html += `</div>`; // close row

        $('#reportContent').html(html);
        $('#viewReportModal').modal('show');
    });

});
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>