
<?php
session_start();
?>
<!doctype html>
<html lang="en" data-theme="light">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover">
  <meta name="color-scheme" content="dark light">
  <title>Loveconnection Admin Panel</title>
  <link rel="stylesheet" type="text/css" href="../assets/css/main.css">
  <link rel="stylesheet" type="text/css" href="../assets/css/utility.css">
  <link rel="stylesheet" href="../assets/bootstrap-icons%401.10.2/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://api.fontshare.com/v2/css?f=satoshi@900,700,500,300,401,400&amp;display=swap">
  <script defer="defer" data-domain="satoshi.webpixels.io"
    src="../assets/plausible.io/js/script.outbound-links.js"></script>
</head>

<body>
  <div class="row g-0 justify-content-center gradient-bottom-right start-purple middle-indigo end-pink">
 
    <div
      class="col-12 col-md-12 col-lg-12  min-vh-100 overflow-y-auto d-flex flex-column justify-content-center position-relative bg-body rounded-top-start-lg-4 border-start-lg shadow-soft-5">
      <div class="w-md-50 mx-auto px-10 px-md-0 py-10">
        <div class="mb-10"><a class="d-inline-block d-lg-none mb-10" href="dashboard.html"><img
              src="https://satoshi.webpixels.io/img/logos/logo-dark.svg" class="h-rem-10" alt="..."></a>
          <h1 class="ls-tight fw-bold h2 text-center">Sign in to your account</h1>
         
        </div>

        <form id="loginForm">
          <div class="mb-5">
            <labesl class="form-label" for="email">Email address</labesl>
            <input type="email"
              class="form-control" id="email">
          </div>
          <div class="mb-5">
            <div class="d-flex justify-content-between gap-2 mb-2 align-items-center"><label class="form-label mb-0"
                for="password">Password</label>
             
            </div>
            <input
              type="password" class="form-control" id="password" autocomplete="current-password">
          </div>
        
          <div>
            <button type="submit" class="btn btn-dark w-100">Sign in</button>
          </div>
        </form>
       
      </div>
    </div>
  </div>
  


<script>
  document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('loginForm').addEventListener('submit', async function (e) {
      e.preventDefault();

      const email = document.getElementById('email').value;
      const password = document.getElementById('password').value;

      try {
        const formData = new FormData();
        formData.append("email", email);
        formData.append("password", password);

        const response = await fetch('https://projects.funtashtechnologies.com/gomeetapi/adminpanel/login.php', {
          method: 'POST',
          body: formData
        });

        if (!response.ok) {
          throw new Error('Network response was not ok');
        }

        const result = await response.json();

        if (result.Result === "true") {
          sessionStorage.setItem("userid", result.userid);
          window.location.href = "home.php";
        } else {
          alert(result.ResponseMsg || "Login failed");
        }
      } catch (error) {
        console.error("Login error:", error);
        alert("Something went wrong. Please try again.");
      }
    });
  });
</script>

  <script src="../assets/js/main.js"></script>
</body>

</html>