<?php


session_start();
$userid = "<script>document.write(sessionStorage.getItem('userid'));</script>";
ob_start();
?>
<main class="container-fluid px-3 py-5 p-lg-6 p-xxl-8">
  <div class="mb-6 mb-xl-10">
    <div class="row g-3 align-items-center">
      <div class="col">
        <h1 class="ls-tight">Dashboard</h1>
      </div>
      <div class="col">
        <div class="hstack gap-2 justify-content-end"><button type="button" class="btn btn-sm btn-square btn-neutral rounded-circle d-xxl-none" data-bs-toggle="offcanvas" data-bs-target="#responsiveOffcanvas" aria-controls="responsiveOffcanvas"><i class="bi bi-three-dots"></i></button> <button type="button" class="btn btn-sm btn-neutral d-none d-sm-inline-flex" data-bs-target="#depositLiquidityModal" data-bs-toggle="modal"><span class="pe-2"><i class="bi bi-plus-circle"></i>
            </span><span>Liquidity</span></button> <a href="page-overview.html" class="btn d-inline-flex btn-sm btn-dark"><span>Trade</span></a></div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="cryptoModal" tabindex="-1" aria-labelledby="cryptoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content overflow-hidden">
        <div class="modal-header pb-0 border-0">
          <h1 class="modal-title h4" id="cryptoModalLabel">Select token</h1><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body p-0">
          <div class="px-6 py-5 border-bottom"><input type="text" class="form-control" placeholder="Search token or paste address" aria-label="Search"></div>
          <div class="p-2">
            <div class="vstack">
              <div class="position-relative d-flex gap-3 p-4 rounded bg-body-secondary-hover">
                <div class="icon flex-none"><img src="https://satoshi.webpixels.io/img/crypto/color/btc.svg" class="w-rem-10 h-rem-10" alt="..."></div>
                <div class="d-flex flex-fill">
                  <div class=""><a href="#" class="stretched-link text-heading fw-bold">BTC</a> <span class="d-block text-muted text-sm">Bitcoin</span></div>
                  <div class="ms-auto fw-bold text-heading">23.8</div>
                </div>
              </div>
              <div class="position-relative d-flex gap-3 p-4 rounded bg-body-secondary-hover">
                <div class="icon flex-none"><img src="https://satoshi.webpixels.io/img/crypto/color/eth.svg" class="w-rem-10 h-rem-10" alt="..."></div>
                <div class="d-flex flex-fill">
                  <div class=""><a href="#" class="stretched-link text-heading fw-bold">ETH</a> <span class="d-block text-muted text-sm">Ethereum</span></div>
                  <div class="ms-auto fw-bold text-heading">1.200,50</div>
                </div>
              </div>
              <div class="position-relative d-flex gap-3 p-4 rounded bg-body-secondary-hover">
                <div class="icon flex-none"><img src="https://satoshi.webpixels.io/img/crypto/color/ada.svg" class="w-rem-10 h-rem-10" alt="..."></div>
                <div class="d-flex flex-fill">
                  <div class=""><a href="#" class="stretched-link text-heading fw-bold">ADA</a> <span class="d-block text-muted text-sm">Cardano</span></div>
                  <div class="ms-auto fw-bold text-heading">10.930,00</div>
                </div>
              </div>
              <div class="position-relative d-flex gap-3 p-4 rounded bg-body-secondary-hover">
                <div class="icon flex-none"><img src="https://satoshi.webpixels.io/img/crypto/color/bnb.svg" class="w-rem-10 h-rem-10" alt="..."></div>
                <div class="d-flex flex-fill">
                  <div class=""><a href="#" class="stretched-link text-heading fw-bold">BNB</a> <span class="d-block text-muted text-sm">Binance</span></div>
                  <div class="ms-auto fw-bold text-heading">200</div>
                </div>
              </div>
              <div class="position-relative d-flex gap-3 p-4 rounded bg-body-secondary-hover">
                <div class="icon flex-none"><img src="https://satoshi.webpixels.io/img/crypto/color/chain.svg" class="w-rem-10 h-rem-10" alt="..."></div>
                <div class="d-flex flex-fill">
                  <div class=""><a href="#" class="stretched-link text-heading fw-bold">CHAIN</a> <span class="d-block text-muted text-sm">Linkchain</span></div>
                  <div class="ms-auto fw-bold text-heading">200</div>
                </div>
              </div>
            </div>
          </div>
          <div class="px-6 py-5 bg-body-secondary d-flex justify-content-center"><button class="btn btn-sm btn-dark"><i class="bi bi-gear me-2"></i>Manage tokens</button></div>
        </div>
      </div>
    </div>
  </div>
  <div class="row g-3 g-xxl-6">
    <div class="col-xxl-12">
      <div class="vstack gap-3 gap-md-6">
        <div class="row g-3">
          <div class="col-md col-sm-6">
            <div class="card border-primary-hover">
              <div class="card-body p-4">
                <div class="d-flex align-items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-people" viewBox="0 0 16 16">
                    <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1zm-7.978-1L7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002-.014.002zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4m3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0M6.936 9.28a6 6 0 0 0-1.23-.247A7 7 0 0 0 5 9c-4 0-5 3-5 4q0 1 1 1h4.216A2.24 2.24 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816M4.92 10A5.5 5.5 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275ZM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0m3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4" />
                  </svg> <a href="page-details.html" class="h4 stretched-link">Total Users</a></div>
                <div id="userCount" class=" fw-bold mt-3"></div>
                <div class="d-flex align-items-center gap-2 mt-1 text-xs"><span class="badge badge-xs bg-success"><i class="bi bi-arrow-up-right"></i>
                  </span><span>+13.7%</span></div>
              </div>
            </div>
          </div>
          <div class="col-md col-sm-6">
            <div class="card border-primary-hover">
              <div class="card-body p-4">
                <div class="d-flex align-items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="bi bi-people" viewBox="0 0 16 16">
                    <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1zm-7.978-1L7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002-.014.002zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4m3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0M6.936 9.28a6 6 0 0 0-1.23-.247A7 7 0 0 0 5 9c-4 0-5 3-5 4q0 1 1 1h4.216A2.24 2.24 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816M4.92 10A5.5 5.5 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275ZM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0m3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4" />
                  </svg> <a href="page-details.html" class="h4 stretched-link">Active Users</a></div>
                <div id="activeuserCount" class=" fw-bold mt-3"></div>
                <div class="d-flex align-items-center gap-2 mt-1 text-xs"><span class="badge badge-xs bg-danger"><i class="bi bi-arrow-up-right"></i>
                  </span><span>-3.2%</span></div>
              </div>
            </div>
          </div>
          <div class="col-md col-sm-6">
            <div class="card border-primary-hover">
              <div class="card-body p-4">
                <div class="d-flex align-items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-patch-question" viewBox="0 0 16 16">
                    <path d="M8.05 9.6c.336 0 .504-.24.554-.627.04-.534.198-.815.847-1.26.673-.475 1.049-1.09 1.049-1.986 0-1.325-.92-2.227-2.262-2.227-1.02 0-1.792.492-2.1 1.29A1.7 1.7 0 0 0 6 5.48c0 .393.203.64.545.64.272 0 .455-.147.564-.51.158-.592.525-.915 1.074-.915.61 0 1.03.446 1.03 1.084 0 .563-.208.885-.822 1.325-.619.433-.926.914-.926 1.64v.111c0 .428.208.745.585.745" />
                    <path d="m10.273 2.513-.921-.944.715-.698.622.637.89-.011a2.89 2.89 0 0 1 2.924 2.924l-.01.89.636.622a2.89 2.89 0 0 1 0 4.134l-.637.622.011.89a2.89 2.89 0 0 1-2.924 2.924l-.89-.01-.622.636a2.89 2.89 0 0 1-4.134 0l-.622-.637-.89.011a2.89 2.89 0 0 1-2.924-2.924l.01-.89-.636-.622a2.89 2.89 0 0 1 0-4.134l.637-.622-.011-.89a2.89 2.89 0 0 1 2.924-2.924l.89.01.622-.636a2.89 2.89 0 0 1 4.134 0l-.715.698a1.89 1.89 0 0 0-2.704 0l-.92.944-1.32-.016a1.89 1.89 0 0 0-1.911 1.912l.016 1.318-.944.921a1.89 1.89 0 0 0 0 2.704l.944.92-.016 1.32a1.89 1.89 0 0 0 1.912 1.911l1.318-.016.921.944a1.89 1.89 0 0 0 2.704 0l.92-.944 1.32.016a1.89 1.89 0 0 0 1.911-1.912l-.016-1.318.944-.921a1.89 1.89 0 0 0 0-2.704l-.944-.92.016-1.32a1.89 1.89 0 0 0-1.912-1.911z" />
                    <path d="M7.001 11a1 1 0 1 1 2 0 1 1 0 0 1-2 0" />
                  </svg> <a href="page-details.html" class="h4 stretched-link">Total Assesments</a></div>
                <div id="assesmentCount" class=" fw-bold mt-3"></div>
                <div class="d-flex align-items-center gap-2 mt-1 text-xs"><span class="badge badge-xs bg-danger"><i class="bi bi-arrow-up-right"></i>
                  </span><span>-2.2%</span></div>
              </div>
            </div>
          </div>
          <div class="col-md col-sm-12">
            <div class="card border-primary-hover">
              <div class="card-body p-4">
                <div class="d-flex align-items-center gap-2">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bullseye" viewBox="0 0 16 16">
                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16" />
                    <path d="M8 13A5 5 0 1 1 8 3a5 5 0 0 1 0 10m0 1A6 6 0 1 0 8 2a6 6 0 0 0 0 12" />
                    <path d="M8 11a3 3 0 1 1 0-6 3 3 0 0 1 0 6m0 1a4 4 0 1 0 0-8 4 4 0 0 0 0 8" />
                    <path d="M9.5 8a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0" />
                  </svg> <a href="page-details.html" class="h4 stretched-link">Goal & Targets</a>
                </div>
                <div id="goalCount" class=" fw-bold mt-3"></div>
                <div class="d-flex align-items-center gap-2 mt-1 text-xs"><span class="badge badge-xs bg-danger"><i class="bi bi-arrow-up-right"></i>
                  </span><span>-2.2%</span></div>
              </div>
            </div>
          </div>
          <!-- <div class="col-md-1 d-none d-md-block">
            <div class="card h-md-100 d-flex flex-column align-items-center justify-content-center py-4 bg-body-secondary bg-opacity-75 bg-opacity-100-hover">
              <a href="#cryptoModal" class="stretched-link text-body-secondary" data-bs-toggle="modal"><i class="bi bi-plus-lg"></i></a>
            </div>
          </div> -->
        </div>

        <div class="card">
          <div class="card-body pb-0">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <h5> Latest Users</h5>
              </div>
              <div class="hstack align-items-center"><a href="#" class="text-muted"><i class="bi bi-arrow-repeat"></i></a></div>
            </div>
            <table class="table table-striped" id="userTable">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Full Name</th>
                  <th>Email</th>
                  <th>Gender</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody id="userList">
                <!-- Rows will be injected here -->
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/totalusers.php',
      method: 'GET',
      dataType: 'json',
      success: function(data) {
        if (data.Result === "true" && data.Count !== undefined) {
          $('#userCount').text(data.Count);
          $('#activeuserCount').text(data.Count);
        } else {
          $('#userCount').text("N/A");
          $('#activeuserCount').text("N/A");
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching user count:', error);
        $('#userCount').text("N/A");
        $('#activeuserCount').text("N/A");
      }
    });
    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/totalgoals.php',
      method: 'GET',
      dataType: 'json',
      success: function(data) {
        if (data.Result === "true" && data.Count !== undefined) {
          $('#goalCount').text(data.Count);
        } else {
          $('#goalCount').text("N/A");
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching user count:', error);
        $('#goalCount').text("N/A");
      }
    });
    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/totalassesments.php',
      method: 'GET',
      dataType: 'json',
      success: function(data) {
        if (data.Result === "true" && data.Count !== undefined) {
          $('#assesmentCount').text(data.Count);
        } else {
          $('#assesmentCount').text("N/A");
        }
      },
      error: function(xhr, status, error) {
        console.error('Error fetching user count:', error);
        $('#assesmentCount').text("N/A");
      }
    });
    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/getallusers.php',
      method: 'GET',
      dataType: 'json',
      success: function(response) {
        if (response.Result === "true" && Array.isArray(response.Data)) {
          const users = response.Data.slice(0, 10); // ✅ Limit to first 10

          users.forEach((user, index) => {
            const fullName = `${user.firstname} ${user.lastname}`;
            const email = user.email;
            const status = user.status;
            const gender = user.gender;
            const id = user.id;

            const userRow = `
          <tr>
            <td>${index + 1}</td>
            <td>${fullName}</td>
            <td>${email}</td>
            <td>${gender}</td>
            <td><span class="badge bg-${status === 'verified' ? 'success' : 'warning'}">${status}</span></td>
            <td>  <a href="user-details.php?id=${id}" class="btn btn-sm btn-primary">View</a></td>
          </tr>
        `;

            $('#userList').append(userRow);
          });
        } else {
          $('#userList').html('<tr><td colspan="6" class="text-danger">Failed to load users.</td></tr>');
        }
      },
      error: function(xhr, status, error) {
        console.error("API Error:", error);
        $('#userList').html('<tr><td colspan="6" class="text-danger">Error fetching users.</td></tr>');
      }
    });
  </script>


</main>


<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>