  <?php
  ob_start();
  ?>
  <main class="container-fluid px-6 pb-10">
    <header class="py-4 border-bottom">
      <div class="row align-items-center">
        <div class="col">
          <div class="d-flex align-items-center gap-4">
            <h2 class="h4 ls-tight">Create Goals And Targets</h2>
          </div>
        </div>
      </div>
    </header>
    <div id="responseMessage" class="mt-3"></div>
    <form id="createAssessmentForm" enctype="multipart/form-data">
      <div class="row g-3 mt-6">
        <div class="col-md-4">
          <label class="form-label">Title</label>
          <input type="text" name="title" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Created By</label>
          <input type="text" name="createdby" class="form-control" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Image</label>
          <input type="file" name="image" class="form-control" required>
        </div>
      </div>
      <div class="d-flex justify-content-end gap-2 mt-5">
        <button type="reset" class="btn btn-sm btn-neutral">Cancel</button>
        <button type="submit" class="btn btn-sm btn-primary">Save</button>
      </div>
    </form>
  </main>
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
  $('#createAssessmentForm').on('submit', function(e) {
  e.preventDefault();

  const formData = new FormData(this); // <-- Proper way to get form including file

  $.ajax({
    url: 'http://localhost/gomeetapi/create/goals/targets',
    method: 'POST',
    data: formData,
    processData: false, // Don't process the files
    contentType: false, // Let jQuery set it as multipart/form-data
    success: function(response) {
      let alertClass = response.Result === "true" ? 'alert-success' : 'alert-danger';
      $('#responseMessage').html(`<div class="alert ${alertClass}">${response.ResponseMsg}</div>`);
      if (response.Result === "true") {
        $('#createAssessmentForm')[0].reset();
        setTimeout(() => window.location.href = 'goalsandtarget.php', 1000);
      }
    },
    error: function() {
      $('#responseMessage').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
    }
  });
});

  </script>

  <?php
  $content = ob_get_clean();
  include '../layouts/master.php';
  ?>
