<?php
ob_start();
?>
<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <div class="row align-items-center d-flex justify-content-center">
      <div class="col">
        <div class="d-flex align-items-center gap-4">
          <h1 class="h4 ls-tight">Add a new Country</h1>
        </div>
      </div>
    </div>
  </header>
  <div id="responseMessage" class="mt-3"></div>
  <form id="addCityForm">
    <div class="row g-3 mt-6 d-flex justify-content-center">
      <div class="col-md-8">
        <label class="form-label">Country Name</label>
        <input type="text" name="country" class="form-control" required>
      </div>
     
    </div>
    <div class="d-flex justify-content-center  gap-2 mt-5">
      <button type="reset" class="btn btn-sm btn-neutral">Cancel</button>
      <button type="submit" class="btn btn-sm btn-primary">Save</button>
    </div>
  </form>

  <!-- Result Message -->

</main>

<!-- jQuery CDN (if not already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $('#addCityForm').on('submit', function(e) {
    e.preventDefault();

    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/countrycreate.php',
      method: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({
        country: $('input[name="country"]').val(),
     
      }),
      success: function(response) {
        let alertClass = response.status ? 'alert-success' : 'alert-danger';
        $('#responseMessage').html(`<div class="alert ${alertClass}">${response.message}</div>`);
        if (response.status) {
          $('#addCityForm')[0].reset();
        }

        // Optional redirect after 2 seconds
        // setTimeout(function() {
        //   window.location.href = 'allcountries.php';
        // }, 2000);
      },
      error: function(xhr, status, error) {
        $('#responseMessage').html('<div class="alert alert-danger">Something went wrong.</div>');
        console.error('Error:', xhr.responseText);
      }
    });
  });
</script>


<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>
