<?php
ob_start();
?>
<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <div class="row align-items-center">
      <div class="col">
        <div class="d-flex align-items-center gap-4">
          <h1 class="h4 ls-tight">Add a new City</h1>
        </div>
      </div>
    </div>
  </header>
  <div id="responseMessage" class="mt-3"></div>
  <form id="addCityForm">
    <div class="row g-3 mt-6">
      <div class="col-md-6">
        <label class="form-label">City</label>
        <input type="text" name="city" class="form-control" required>
      </div>


      <div class="col-md-6">
        <label class="form-label">Country</label>
        <select name="country" class="form-control" id="countrySelect" required>
          <option value="">Select Country</option>
        </select>
      </div>

    </div>

    <hr class="my-6">
    <div class="d-flex justify-content-end gap-2">
      <button type="reset" class="btn btn-sm btn-neutral">Cancel</button>
      <button type="submit" class="btn btn-sm btn-primary">Save</button>
    </div>
  </form>

  <!-- Result Message -->

</main>

<!-- jQuery CDN (if not already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
  $('#addCityForm').on('submit', function(e) {
    e.preventDefault();

    $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/createcity.php',
      method: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({
        city: $('input[name="city"]').val(),
        country: $('input[name="country"]').val()
      }),
      success: function(response) {
        let alertClass = response.status ? 'alert-success' : 'alert-danger';
        $('#responseMessage').html(`<div class="alert ${alertClass}">${response.message}</div>`);
        if (response.status) {
          $('#addCityForm')[0].reset();
        }
        setTimeout(function() {
          window.location.href = 'cities.php'; // Redirect to cities list
        }, 1000);
      },
      error: function(xhr, status, error) {
        $('#responseMessage').html('<div class="alert alert-danger">Something went wrong.</div>');
        console.error('Error:', xhr.responseText);
      }
    });
 $.ajax({
      url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/getcountry.php',
      method: 'GET',
      dataType: 'json',
      success: function (response) {
        console.log(response); // ✅ Check what's coming
        if (response.Result === "true" && Array.isArray(response.Data)) {
          response.Data.forEach(function (item) {
            $('#countrySelect').append(`<option value="${item.country}">${item.country}</option>`);
          });
        } else {
          $('#countrySelect').append('<option value="">No data found</option>');
        }
      },
      error: function (xhr, status, error) {
        console.error("Error loading countries:", error);
        $('#countrySelect').append('<option value="">Error loading</option>');
      }
    });

  });
</script>


<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>