<?php
ob_start();
?>
<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <div class="row align-items-center">
      <div class="col">
        <div class="d-flex align-items-center gap-4">
          <h1 class="h4 ls-tight">Create Assessment</h1>
        </div>
      </div>
    </div>
  </header>
  <div id="responseMessage" class="mt-3"></div>

  <form id="createAssessmentForm">
    <div class="row g-3 mt-6">
      <div class="col-md-6">
        <label class="form-label">User ID</label>
        <input type="number" name="userid" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Type</label>
        <input type="text" name="type" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Category ID</label>
        <input type="number" name="categoryid" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Question ID</label>
        <input type="number" name="questionid" class="form-control" required>
      </div>
      <div class="col-md-12">
        <label class="form-label">Answer</label>
        <textarea name="answer" class="form-control" required></textarea>
      </div>
      <div class="col-md-6">
        <label class="form-label">Rating (1-5)</label>
        <input type="number" name="rating" class="form-control" min="1" max="5" required>
      </div>
    </div>
    <div class="d-flex justify-content-end gap-2 mt-5">
      <button type="reset" class="btn btn-sm btn-neutral">Cancel</button>
      <button type="submit" class="btn btn-sm btn-primary">Save</button>
    </div>
  </form>
</main>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
  $('#createAssessmentForm').on('submit', function(e) {
    e.preventDefault();

    const formData = {
      userid: $('input[name="userid"]').val(),
      type: $('input[name="type"]').val(),
      categoryid: $('input[name="categoryid"]').val(),
      questionid: $('input[name="questionid"]').val(),
      answer: $('textarea[name="answer"]').val(),
      rating: $('input[name="rating"]').val()
    };

    $.ajax({
      url: 'http://localhost/gomeetapi/createassessment',
      method: 'POST',
      contentType: 'application/json',
      data: JSON.stringify(formData),
      success: function(response) {
        let alertClass = response.Result === "true" ? 'alert-success' : 'alert-danger';
        $('#responseMessage').html(`<div class="alert ${alertClass}">${response.ResponseMsg}</div>`);
        if (response.Result === "true") {
          $('#createAssessmentForm')[0].reset();
          setTimeout(() => window.location.href = 'assesmentanswers.php', 1000);
        }
      },
      error: function() {
        $('#responseMessage').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
      }
    });
  });
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>
