<?php
ob_start();
?>
<main class="container-fluid px-6 pb-10">
    <header class="py-4 border-bottom">
        <div class="row align-items-center">
            <div class="col">
                <div class="d-flex align-items-center gap-4">
                    <h1 class="h4 ls-tight">Add new category</h1>
                </div>
            </div>
        </div>
    </header>
    <div id="responseMessage" class="mt-3"></div>
    <form id="addCityForm" enctype="multipart/form-data">
        <div class="row g-3 mt-6">
            <div class="col-md-6">
                <label class="form-label">Image</label>
                <input type="file" name="image" class="form-control" accept="image/*" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>
        </div>

        <hr class="my-6">
        <div class="d-flex justify-content-end gap-2">
            <button type="reset" class="btn btn-sm btn-neutral">Cancel</button>
            <button type="submit" class="btn btn-sm btn-primary">Save</button>
        </div>
    </form>

    <!-- Result Message -->

</main>

<!-- jQuery CDN (if not already included) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
   $('#addCityForm').on('submit', function(e) {
    e.preventDefault();

    const formData = new FormData();
    formData.append('title', $('input[name="title"]').val());
    formData.append('createdby', 'superadmin');
    formData.append('image', $('input[name="image"]')[0].files[0]);

    $.ajax({
        url: 'https://projects.funtashtechnologies.com/gomeetapi/adminpanel/createassessmentcategories.php',
        method: 'POST',
        data: formData,
        processData: false,  // ✅ must be false for FormData
        contentType: false,  // ✅ must be false for FormData
        success: function(response) {
            console.log(response);
            let alertClass = response.Result === "true" ? 'alert-success' : 'alert-danger';
            $('#responseMessage').html(`<div class="alert ${alertClass}">${response.ResponseMsg}</div>`);
            if (response.Result === "true") {
                $('#addCityForm')[0].reset();
                 setTimeout(() => window.location.href = 'assesmentcategories.php', 1000);
            }
        },
        error: function(xhr, status, error) {
            console.error("XHR Response Text:", xhr.responseText);
            $('#responseMessage').html('<div class="alert alert-danger">Something went wrong.</div>');
        }
    });
});
</script>


<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>